/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import java.awt.Frame;
import javax.swing.JPanel;

public abstract class VWStepPropTabPanel
extends JPanel {
    protected static final int TYPE_NONE = 0;
    protected static final int TYPE_GENERAL = 1;
    protected static final int TYPE_ATTACHMENT = 2;
    protected static final int TYPE_ASSIGNMENT = 3;
    protected static final int TYPE_FIELD = 4;
    protected static final int TYPE_WORKFLOW_GROUP = 5;
    protected static final int TYPE_ROUTING = 6;
    protected static final int TYPE_PARAMETER = 7;
    protected static final int TYPE_RULE = 8;
    protected int m_type = 0;
    protected Frame m_parentFrame = null;
    protected VWBaseStepPropPanel m_propPanel = null;
    protected VWTrkStep m_step = null;
    protected VWTrkStepOccurrence m_stepOccurrence = null;
    protected boolean m_bStepView = true;
    protected VWTrkParticipant m_participant = null;
    protected int m_selectionChanged = 0;
    protected boolean m_bDataUpdated = false;
    protected boolean m_bDisplayUpdated = false;
    protected boolean m_bLayoutInitialized = false;

    protected abstract void setupLayout();

    protected abstract void initData() throws Exception;

    protected abstract void updateDisplay();

    public VWStepPropTabPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        this.m_parentFrame = parentFrame;
        this.m_propPanel = propPanel;
        this.setSelection();
        this.m_bLayoutInitialized = false;
        this.m_selectionChanged = 4;
    }

    protected void setDataUpdated(boolean bUpdated) {
        this.m_bDataUpdated = bUpdated;
    }

    protected boolean isDataUpdated() {
        return this.m_bDataUpdated;
    }

    protected boolean isDisplayUpdated() {
        return this.m_bDisplayUpdated;
    }

    protected void setDisplayUpdated(boolean bUpdated) {
        this.m_bDisplayUpdated = bUpdated;
    }

    protected void setSelectionChanged(int flag) {
        if (this.isDataUpdated() && this.isDisplayUpdated()) {
            this.m_selectionChanged = flag;
        } else if (flag > this.m_selectionChanged) {
            this.m_selectionChanged = flag;
        }
        boolean bUpdated = this.m_selectionChanged == 0;
        this.setDataUpdated(bUpdated);
        this.setDisplayUpdated(bUpdated);
    }

    boolean isSelectionChanged() {
        if (this.m_selectionChanged == 0) {
            return false;
        }
        return !this.m_bDataUpdated || !this.m_bDisplayUpdated;
    }

    public void init() throws Exception {
        if (this.isSelectionChanged()) {
            this.initData();
            this.setDataUpdated(true);
            if (!this.m_bLayoutInitialized) {
                this.setupLayout();
                this.m_bLayoutInitialized = true;
                this.setDisplayUpdated(true);
            } else {
                this.updateDisplay();
                this.setDisplayUpdated(true);
            }
            this.setSelectionChanged(0);
        }
    }

    public boolean isInitialized() {
        return this.m_bLayoutInitialized && this.m_bDataUpdated && this.m_bDisplayUpdated;
    }

    protected void setSelection() {
        int change = 0;
        VWTrkStep step = this.getSelectedStep();
        VWTrkStepOccurrence stepOccurrence = this.getSelectedStepOccurrence();
        VWTrkParticipant participant = this.getSelectedParticipant();
        boolean bStepView = this.isStepView();
        if (this.m_step != step) {
            change = 4;
        } else if (stepOccurrence != this.m_stepOccurrence) {
            change = 3;
        } else if (bStepView != this.m_bStepView) {
            change = 2;
        } else if (this.m_participant != participant) {
            change = 1;
        }
        this.m_step = step;
        this.m_stepOccurrence = stepOccurrence;
        this.m_bStepView = bStepView;
        this.m_participant = participant;
        this.setSelectionChanged(change);
    }

    protected void refresh() {
        this.setSelectionChanged(3);
    }

    protected boolean isLiveData() {
        boolean bActive = false;
        if (this.m_bStepView) {
            if (this.m_stepOccurrence != null) {
                bActive = this.m_stepOccurrence.isActive();
            }
        } else if (this.m_participant != null) {
            bActive = this.m_participant.isActive();
        }
        return bActive;
    }

    protected boolean isDataEditable() {
        boolean bEditable = false;
        if (this.m_bStepView) {
            if (this.m_stepOccurrence != null) {
                bEditable = this.m_stepOccurrence.isDataEditable();
            }
        } else if (this.m_participant != null) {
            bEditable = this.m_participant.isDataEditable();
        }
        return bEditable;
    }

    protected boolean isLockedByOther() {
        boolean bReturn = false;
        if (this.m_bStepView) {
            if (this.m_stepOccurrence != null) {
                bReturn = this.m_stepOccurrence.isLockedByOther();
            }
        } else if (this.m_participant != null) {
            bReturn = this.m_participant.isLockedByOther();
        }
        return bReturn;
    }

    protected VWTrkStep getSelectedStep() {
        if (this.m_propPanel != null) {
            return this.m_propPanel.getSelectedStep();
        }
        return null;
    }

    protected VWTrkStepOccurrence getSelectedStepOccurrence() {
        if (this.m_propPanel != null) {
            return this.m_propPanel.getSelectedOccurrence();
        }
        return null;
    }

    protected VWTrkParticipant getSelectedParticipant() {
        if (this.m_propPanel != null) {
            return this.m_propPanel.getSelectedParticipant();
        }
        return null;
    }

    protected boolean isStepView() {
        if (this.m_propPanel != null) {
            return this.m_propPanel.isStepView();
        }
        return true;
    }

    protected int getType() {
        return this.m_type;
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_propPanel = null;
        this.m_step = null;
        this.m_stepOccurrence = null;
        this.m_participant = null;
        this.removeAll();
    }
}

